#ifndef	_LCDLIB_H_
#define	_LCDLIB_H_

//SUNLIKE [SC1602]												|[SD1602]
//pin:	14	13	12	11	10	9	8	7	6	5	4	3	2	1	|16	15
//bit:	DB7	DB6	DB5	DB4	DB3	DB2	DB1	DB0	E	R/W	RS	Vo	VDD	VSS	|K	A
//		<- 4bit mode ->									+V	GND	|-	+


#include	<avr/io.h>
#include	<util/delay.h>

//gp|[giP̃|[gj
#define	LCD_PORT	PORTA
#define	LCD_DDR		DDRA

//|[g̃rbg̊蓖āi4bit[hOj
#define	LCD_FIXBITS	((1 << PA6) | (1 << PA7))	//LCD̐Ƃ͖֌Wȃrbgɒ`i0j
#define	LCD_RS		(1 << PA0)	//Register Select	H:data	L:command
#define	LCD_RW		0			//Read/Write		H:read	L:write		gpin[hIwriteŒj
#define	LCD_E		(1 << PA1)	//Enable Signal		H->L:strobe
#define	LCD_DATABITS_SHIFT	2	//PD3-PD0	iLSB牽rbg߂f[^rbgBFbit3-0Ȃ0Abit7-4Ȃ4j
#define	LCD_DATABITS	(0x0F << LCD_DATABITS_SHIFT)
#define	LCD_DATABITS_REVERSE	0	//f[^4bit̐ڑΉ	0:[MSB/DB7`DB4/LSB]	1:[MSB/DB4`DB7/LSB]

//R}h
void	lcdInit();
void	lcdCmd(uint8_t bits);
void	lcdPutChar(char c);
//void	lcdPutStr(const char* s);
//void	lcdPutUInt(uint16_t n);
//void	lcdPutInt(int16_t n);
//void	lcdDefChar(uint8_t id, const uint8_t* dots);

#define	lcdCls()		lcdCmd(LCD_CMD_CLEAR_DISPLAY)
#define	lcdSetPos(r, c)	lcdCmd(LCD_CMD_SET_DDRAM_ADRS | ((r) * 0x40 + (c)))
#define	lcdBitReset()	LCD_PORT &= LCD_FIXBITS

//Instruction
#define	LCD_CMD_CLEAR_DISPLAY	0b00000001
#define	LCD_CMD_RETURN_HOME		0b00000010
#define	LCD_CMD_ENTRY_MODE		0b00000100
#define	LCD_CMD_DISPLAY_MODE	0b00001000
#define	LCD_CMD_CURSOR_MODE		0b00010000
#define	LCD_CMD_FUNCTION_SET	0b00100000
#define	LCD_CMD_SET_CGRAM_ADRS	0b01000000
#define	LCD_CMD_SET_DDRAM_ADRS	0b10000000

//Instructioñp[^
//(LCD_CMD_AAA | LCD_SUBCMD_XXX1 | LCD_SUBCMD_XXX2 | c)̌`Ŏg

//LCD_CMD_ENTRY_MODE
#define	LCD_SUBCMD_INCREMENT	0b00000010	//͈ʒui߂iw肾Decrementj
#define	LCD_SUBCMD_WITH_SHIFT	0b00000001	//\Vtg𔺂iLCD_CMD_CURSOR_MODEݒ肷j

//LCD_CMD_DISPLAY_MODE
#define	LCD_SUBCMD_SET_DISPLAY	0b00000100	//ʕ\iw肾ƕ\eۂ܂܉ʂj
#define	LCD_SUBCMD_SET_CURSOR	0b00000010	//J[\\iA_[o[\j
#define	LCD_SUBCMD_CURSOR_BLINK	0b00000001	//J[\_łiɔ킳č}X_łj

//LCD_CMD_CURSOR_MODE
#define	LCD_SUBCMD_SHIFT_ON		0b00001000	//DDRAM̕ύXɕ\Vtgiw肾ƃJ[\ړj
#define	LCD_SUBCMD_RIGHT		0b00000100	//EփVtgiw肾ƍցjLAJ[\ړ[h͈ӖȂ

//LCD_CMD_FUNCTION_SET
#define	LCD_SUBCMD_DL8BIT		0b00010000	//Data Length 8-bitiw肾4-bit[hj
#define	LCD_SUBCMD_2LINE		0b00001000	//\2sgpiw肾1ŝݎgp\ɂȂj
#define	LCD_SUBCMD_FONT5X10		0b00000100	//Font Type 5x10iw肾5x8jSC1602/SD1602͕IɔΉ


#endif	//_LCDLIB_H_
