//	USB[d d͌v
//	wt]xH쎺	http://jsdiy.web.fc2.com

/*
y|[gΉz	ATtiny20	x:݂Ȃ(PB3RESET) -:
bit		7	6	5	4	3	2	1	0
portA	ADC	-	LCD	LCD	LCD	LCD	LCD	LCD		dv,LCD
portB	x	x	x	x	TPI	-	TPI	TPI		ISP

yATtiny20z
|-AAAAAA|
|G012345|
>       |
|V01R276|
|-BB-BAA|

yq[Yrbgz(hidtpiw.exe -rf)
Low: -111-111 (FF)
      ||| ||+-- RSTDISBL (1:RESETgp, 0:RESET(PB3))
      ||| |+-- WDTON (WDT 0:펞ON, 1:ʏ)
      ||| +-- CKOUT (0:CLKOɃVXeNbNo)
      +++-- BODLEVEL[2:0] (111:Off, 110:1.8, 101:2.7, 100:4.3)

yrhz
WindowsXP/SP3(32bit)
AVR Studio5.1	œKIvV: -Os
AVR GCC 8-bit Toolchain	Version: avr-toolchain-installer-3.4.1.1195-win32.win32.x86.exe
ATtiny20	1MHzi8MHz/8j

yXVz
2012/09/25	v0.90	Program:    1910 bytes (93.3% Full)
					Data:          5 bytes (3.9% Full)
				ubh{[hŊB

2012/09/28	v1.00	Program:    1842 bytes (89.9% Full)
					Data:          5 bytes (3.9% Full)
				ŎdグBɔLCD̔zύXB
*/

/*	yATtiny10V[Ygp̒ӎz
E݂ėpWX^R16-R31^R17̓[WX^BX:R26-R27(Lo-Hi), Y:R28-R29(Lo-Hi), Z:R30-R31(Lo-Hi)
EI/Os̃vAbvPORTxWX^ł͂ȂPUExWX^Őݒ肷B
*/

#include	<avr/io.h>
#include	<avr/sleep.h>
#include	<avr/pgmspace.h>
#include	<avr/interrupt.h>
#include	<util/delay.h>
#include	"lcdlib.h"

//C^[o(1`4b)
#define	SLEEP_INTERVAL_SEC	1

//LCD̕\ʒu
/*	0123456789012345	0123456789012345
	5V 0000mA 00:00 	5V 1000mA 1000h 
	00.0mAh 00.00Wh 	10000Ah 50000Wh 	*/
#define	P_MA	3
#define	P_HH	10
#define	P_MM	13
#define	P_MAH	0
#define	P_WH	8
#define	P_L1C	0
#define	P_L2C	4
					//0123456789012345
#define	S_LINE1	PSTR("5V     mA   :"   )
#define	S_LINE2	PSTR(    "mAh      Wh" )

//\ivÖ悩璼ځj
static	void	lcdPutStrP(PGM_P s)
{
	char cc;
	while ((cc = pgm_read_byte(s++)) != 0)
        lcdPutChar(cc);
}

//\iw{l)
//
//num:	\l
//keta:	l̉\邩(1<=n<=5)
//cc:	pfBO镶
static	char	kbuf[5];	//16bit͍ő5
static	void	lcdNumDisplay(uint16_t num, uint8_t keta, char cc)
{
	uint8_t	i;
	
	for (i = 0; i < 5; i ++) kbuf[i] = cc;
	
	i = 0;
	do
	{
		kbuf[i++] = '0' + (num % 10);
		num /= 10;
	}
	while (0 < num);
	
	while (0 < keta)
		lcdPutChar(kbuf[--keta]);
}

//LCDɑ\
//
//mAmp:		݂̓dl[mA]	n<=1000[mA]i1000mA邱Ƃj
//mm:		oߎ[]	n<=60000[]i1000ԁj
//ampHour:		mAsecAhɊZƂ̐		0<=n<=10000
//mAmpHourPart:	mAsecmAhɊZƂ̐ŁAAAhɊZƂ̒[	0<=n<1000
//mAmpSecPart:	mAsecmAhɊZƂ̒[	0<=n<3600
static	void	lcdDisplay(uint16_t mAmp, uint16_t mm, uint16_t ampHour, uint16_t mAmpHourPart, uint16_t mAmpSecPart)
{
	uint16_t	mAmpHourNum, mWattHourTmp, wattHourNum;
	uint8_t		mAmpHourDec, wattHourDec;
	
	mAmpHourNum = mAmpHourPart;
	mAmpHourDec = (uint8_t)(mAmpSecPart / 360);	//1ʂ܂	̈Ӗ  mAmpSecPart3600~10
	
	mWattHourTmp = mAmpHourNum * 5;
	wattHourNum = ampHour * 5 + mWattHourTmp / 1000;	//	[Wh]=[Ah]*5[V]+([mAh]*5[V]/1000) <=50000[Wh]
	wattHourDec = (uint8_t)((mWattHourTmp % 1000) / 10);	//2ʂ܂
	
	//݂̓dl
	lcdSetPos(0, P_MA);	lcdNumDisplay(mAmp, 4, ' ');
	
	//oߎ
	if (mm < 60 * 100)
	{
		//100Ԗ̏ꍇA_0:00`99:59ƕ\
		lcdSetPos(0, P_HH);	lcdNumDisplay(mm / 60, 2, ' ');
		lcdSetPos(0, P_MM);	lcdNumDisplay(mm % 60, 2, '0');
	}
	else
	{
		//100Ԉȏ̏ꍇA_100h`1000hƕ\
		lcdSetPos(0, P_HH);	lcdNumDisplay(mm / 60, 4, ' ');
		lcdPutChar('h');
	}
	
	//d
	//1000mAhI[_[̕\L͓dreʂȂǂł悭̂ŁAmAh/Ah̕\L𕪂
	lcdSetPos(1, P_MAH);
	if (ampHour < 10)
	{
		//10Ah̏ꍇA0mAh`9999mAhƕ\
		mAmpHourNum += ampHour * 1000;
		
		if (mAmpHourNum < 100)
		{
			//Ƃ킯100mAh̏ꍇA_0.0mAh`99.9mAhƕ\
			lcdNumDisplay(mAmpHourNum, 2, ' ');
			lcdPutChar('.');
			lcdPutChar('0' + mAmpHourDec);
		}
		else
		{
			//_100mAh`9999mAh
			lcdNumDisplay(mAmpHourNum, 4, ' ');
		}
	}
	else if (ampHour < 1000)
	{
		//1000Ah̏ꍇA_10.0Ah`999.9Ahƕ\iE[mAhmɏdȂ悤ɂj
		lcdNumDisplay(ampHour, 3, ' ');
		lcdPutChar('.');
		lcdPutChar('0' + mAmpHourNum / 100);
	}
	else
	{
		//1000Ahȏ̏ꍇA_1000Ah`10000Ahƕ\iE[mAhmɏdȂ悤ɂj
		lcdNumDisplay(ampHour, 5, ' ');
	}
	
	//d͗
	lcdSetPos(1, P_WH);
	if (wattHourNum < 100)
	{
		//_0.00Wh`99.99Wh
		lcdNumDisplay(wattHourNum, 2, ' ');
		lcdPutChar('.');
		lcdNumDisplay(wattHourDec, 2, '0');
	}
	else if (wattHourNum < 1000)
	{
		//100.0Wh`999.9Wh
		lcdNumDisplay(wattHourNum, 3, ' ');
		lcdPutChar('.');
		lcdPutChar('0' + wattHourDec / 10);
	}
	else
	{
		//_1000Wh`50000Wh
		lcdNumDisplay(wattHourNum, 5, ' ');
	}
}

//A/DϊX[v̕A
ISR(ADC_ADC_vect)
{
	//Ȃ
}

//^C}[JE^荞
ISR(TIM1_COMPA_vect)
{
	//Ȃ
}

int main(void)
{
	uint16_t	adcValue;	//ADC̕ϊl
	uint16_t	mAmp, totalMAmpHourPart = 0, totalMAmpSecPart = 0;	//d[mA], ̗ݐϒl
	uint16_t	totalAmpHour = 0;	//totalMAmpHourPart[mAh][Ah]PʂɊZƂ̐
	uint16_t	mm = 0;	//oߎ()
	uint8_t		ss = 0;	//oߎ(b)
	uint8_t	isAmpCount = 1, isTimeCount = 1;	//stOi1:s 0:Xgbvj
	uint8_t	i;
	
	//mCYጸ҂ADCgpsvAbvĂ
	DDRA	= (1 << PA6);	//o͕
	PORTA	= (1 << PA6);	//Hio
	PUEA	= (1 << PA6);	//vAbv
	
	//d͍팸̂ߖgp@\~(1)
	PRR = (1 << PRTWI) | (1 << PRSPI) | (0 << PRTIM1) | (1 << PRTIM0);	//PRTIM1=16bit^C}[
	ACSRA = (1 << ACD);		//AiORp[^
	DIDR0 = (1 << ADC7D);	//ADCgpsfW^͋֎~ɂiAiOpƂȂj	//PA7
	
	//ADCݒ
	//ADPS2-0: ADC(50k`200kHzł邱)
	//E000;001:2, 010:4, 011:8, 100:16, 101:32, 110:64, 111:128
	ADCSRA = (1 <<ADEN) |		//ADCL
			(1 << ADIE) |		//荞݋iADCmCYጸX[vgp̂Łj
			(0b011 << ADPS0);	//1MHz/8=125kHz
	
	//ADC̊dƓ̓sݒ肷
	//REFS -> 0:VCC, 1:1.1V
	//MUX0 -> 0000-0111:PA0-PA7, 1000:I0Vڑ, 1001:I1.1Vڑ
	ADMUX = (0 << REFS) | (0b0111 << MUX0);
	_delay_ms(10);	//dؑւ̈҂
	
	//16bit^C}[JE^
	//TCCR1B:WGM13,12,TCCR1A:WGM11,10 = 0100:rv(OCR1A)
	//TCCR1B:CS12,11,10 = 000:~, 001:Ȃ, 010:8, 011:64, 100:256, 101:1024
	TCCR1A = (0b00 << WGM10);
	TCCR1B = (0b01 << WGM12) | (0b011 << CS00);	//1MHz/64=15625JEg/b
	OCR1A = 15625 * SLEEP_INTERVAL_SEC - 1;	//JEgݒ
	TIMSK = (1 << OCIE1A);	//^C}[JE^L
	
	//LCD
	lcdInit();
	lcdSetPos(0, P_L1C);	lcdPutStrP(S_LINE1);
	lcdSetPos(1, P_L2C);	lcdPutStrP(S_LINE2);
	
	sei();	//荞݊Jn
	while (1)
	{
		//ADCN
		PRR &= ~(1 << PRADC);	//ADC@\ɓd͂(0)
		ADCSRA |= (1 << ADEN);	//ADCL(1)
		
		//4ϊĕς
		adcValue = 0;
		set_sleep_mode(SLEEP_MODE_ADC);
		for (i = 0; i < 4; i++)
		{
			//ADCmCYጸX[vJncϊcϊ
			sleep_mode();
			adcValue += (ADC * 10);		//ϊloiľܓlA10{lŉZj
		}
		adcValue = (adcValue + 20) / 40;	//ľܓϒl	//ADC<1024  (ADC*10)*4+20<65535
		
		//A/Dϊld߁AdZo
		//fv = adcValue * 5V / 1024 / (1+47k/1k) [V]
		//fa = fv / 0.1 * 1000 [mA]
		//	= adcValue * 5 / 1024 / 48 / 0.1 * 1000
		//	= adcValue * 1.017 [mA]
		mAmp = adcValue * 59 / 58;	//adcValue<1024  adcValue*59<65535
		
		//dʂݐς
		//toolchain-3.4.1łtiny10V[YɂfloatZ̃T|[gsSȖ͗lirhG[jB
		//	̂ߐ^pĉL̂悤ȕ@̂B
		//E肵dlϐaɑłBϐamAsec̒l\B̂܂܂ƒȂI[o[t[B
		//Eϐa̒lmAhɊZɂ3600Ŋ(mAsec/3600=mAh)B
		//	Ȃ΁Aϐa3600𒴂邲Ƃɕʂ̕ϐbɗݐςĂ΂悢Bϐb͂̂܂mAh̒l\B
		//EɁAϐb1000𒴂邲Ƃɕʂ̕ϐcɗݐςĂBϐc͂̂܂Ah̒l\(mAh/1000=Ah)B
		//F펞1000mA100ԗꂽꍇ̓dʂ́A
		//	1000mA * 100h = 1000mA * 100 * 3600sec = 360000000mAsec = 100000mAh = 100Ah
		//	-> 360000[a:000]mAsec -> [c:100][b:000]mAh -> [c:100]Ah, Ȃ݂ a/3600=0.N[mAh]
		if (isAmpCount)
		{
			totalMAmpSecPart += (mAmp * SLEEP_INTERVAL_SEC);
			if (3600 <= totalMAmpSecPart)
			{
				totalMAmpSecPart -= 3600;
				if (1000 <= ++totalMAmpHourPart)
				{
					totalMAmpHourPart -= 1000;
					if (++totalAmpHour == 10000) isAmpCount = 0;	//10000AhŃJEgXgbv
				}
			}
		}
		
		//\
		lcdDisplay(mAmp, mm, totalAmpHour, totalMAmpHourPart, totalMAmpSecPart);
		
		//d͍팸̂ADC@\~
		ADCSRA &= ~(1 << ADEN);	//ADC(0)
		PRR |= (1 << PRADC);	//ADC@\ւ̓d͂~(1)
		
		//񑪒莞܂őҋ@X[vJn
		set_sleep_mode(SLEEP_MODE_IDLE);
		sleep_mode();
		//yҋ@X[vz
		
		//yҋ@X[vz
		if (isTimeCount)
		{
			ss += SLEEP_INTERVAL_SEC;
			if (60 <= ss)
			{
				ss -= 60;
				if (++mm == 60 * 1000) isTimeCount = 0;		//1000ԂŃJEgXgbv
			}
		}
	}
	
	return 0;
}
