﻿using System.Drawing;

namespace RayTracingTest
{
	enum BayerMatrixSize
	{
		M2x2 = 2,
		M3x3 = 3,
		M4x4 = 4
	}

	class OrderedDither	: IDither
	{
		/*
		  ---------------------------------------------------------------------
		00|   |   |   |   |   |FF	区間    <5区間>
		  |   33  66  99  CC  |		閾値    <4個> +51d(=255/5区間)
		      0   1   2   3			Bayer配列の要素番号（閾値のインデックス）
		  ---------------------------------------------------------------------
		00|   |   |   |   |   |   |   |   |   |   |FF	区間    <10区間>
		  |   1A  34  4E  68  82  9C  B6  D0  EA  |		閾値    <9個> +26d(=255/10区間)
		      0   1   2   3   4   5   6   7   8			Bayer配列の要素番号（閾値のインデックス）
		  ---------------------------------------------------------------------
		00|   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |FF	区間    <17区間>
		  |   0F  1E  2D  3C  4B  5A  69  78  87  96  A5  B4  C3  D2  E1  F0  |		閾値    <16個> +15d(=255/17区間)
		      0   1   2   3   4   5   6   7   8   9   10  11  12  13  14  15		Bayer配列の要素番号（閾値のインデックス）
		  ---------------------------------------------------------------------
		*/

		//dither-matrix
		private readonly byte[][] BayerMatrixList =
		{
			new byte[]
			{
				0, 2,
				3, 1
			},
			new byte[]
			{
				2, 6, 3,
				5, 0, 8,
				1, 7, 4
			},
			new byte[]
			{
				 0,  8,  2, 10,
				12,  4, 14,  6,
				 3, 11,  1,  9,
				15,  7, 13,  5
			}
		};

		private readonly byte[] ThresholdStepList = { 51, 26, 15 };
		
		private readonly byte[] Palette16 = { 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF };	//16階調
		private readonly byte[] Palette8 = { 0x00, 0x00, 0x24, 0x24, 0x48, 0x48, 0x6C, 0x6C, 0x90, 0x90, 0xB4, 0xB4, 0xD8, 0xD8, 0xFF, 0xFF };	//8階調
		private readonly byte[] Palette4 = { 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF };  //4階調

		private readonly int MatrixSize;
		private readonly byte[] DitherMatrix;
		private readonly int ThresholdStep;

		//コンストラクタ
		public OrderedDither(BayerMatrixSize matrixSize = BayerMatrixSize.M4x4)
		{
			MatrixSize = (int)matrixSize;
			int idx = (int)matrixSize - 2;  //enum値から0開始のインデックス値へ変換

			ThresholdStep = ThresholdStepList[idx];
			byte[] srcMatrix = BayerMatrixList[idx];
			DitherMatrix = new byte[srcMatrix.Length];
			for (int i = 0; i < DitherMatrix.Length; i++)
			{
				DitherMatrix[i] = (byte)((srcMatrix[i] + 1) * ThresholdStep);
			}
		}

		public Color Dithering(int canvasX, int canvasY, Color color)
		{
			int column = canvasX % MatrixSize;
			int row = canvasY % MatrixSize;
			int midx = row * MatrixSize + column;
			int threshold = DitherMatrix[midx];

			//*
			byte rr = Distribute2(color.R, threshold);
			byte gg = Distribute2(color.G, threshold);
			byte bb = Distribute2(color.B, threshold);
			//*/
			/*
			byte rr = Distribute(color.R, threshold, Palette16);
			byte gg = Distribute(color.G, threshold, Palette16);
			byte bb = Distribute(color.B, threshold, Palette16);
			//*/
			return Color.FromArgb(rr, gg ,bb);
		}

		//色の振り分け(2階調)
		private byte Distribute2(byte colorElement, int threshold)
		{
			return (byte)(threshold <= colorElement ? 0xFF : 0x00);
		}

		//色の振り分け(N階調)
		private byte Distribute(byte colorElement, int threshold, byte[] palette)
		{
			if (threshold <= colorElement)
			{
				for (int i = 0; i < palette.Length; i++)
				{
					if (colorElement <= palette[i]) { return palette[i]; }
				}
				return palette[palette.Length - 1];		//上限を0xFFまで網羅していないパレットの場合
			}
			else
			{
				for (int i = palette.Length - 1; 0 <= i; i--)
				{
					if (palette[i] <= colorElement) { return palette[i]; }
				}
				return palette[0];    //下限を0x00まで網羅していないパレットの場合
			}
		}
	}
}
