﻿//「レイトレーシングとディザによる減色の実験」
//	『昼夜逆転』工作室	@jsdiy
/*
【内容】
(1)減色なし、(2)パターン行列による減色、(3)誤差拡散による減色、の処理結果を描画する。

【履歴】
2017/09/19	ver1.00
*/

using System;
using System.Drawing;
using System.Windows.Forms;

namespace RayTracingTest
{
	public partial class FmMain : Form
	{
		private RayTracing rayTracing;
		private Bitmap canvas;

		public FmMain()
		{
			InitializeComponent();
			rayTracing = new RayTracing(DrawPixel);

			Size screenSize = rayTracing.GetScreenSize();
			canvas = new Bitmap(screenSize.Width, screenSize.Height);
			pbCanvas.Image = canvas;
			pbCanvas.Size = pbCanvas.Image.Size;
			pnl.Top = pbCanvas.Bottom;
			this.ClientSize = new Size(Math.Max(pbCanvas.Width, cbDitherType.Width), pnl.Bottom);
		}

		private void FmMain_Shown(object sender, EventArgs e)
		{
			cbDitherType.SelectedIndex = (int)DitherType.None;
		}

		private void FmMain_FormClosing(object sender, FormClosingEventArgs e)
		{
			canvas.Dispose();
		}

		private void cbDitherType_SelectedIndexChanged(object sender, EventArgs e)
		{
			DoRendering();
		}

		private void chkGrayScale_CheckedChanged(object sender, EventArgs e)
		{
			DoRendering();
		}

		private void DoRendering()
		{
			rayTracing.Rendering((DitherType)cbDitherType.SelectedIndex, chkGrayScale.Checked);
			pbCanvas.Refresh();
		}

		//RayTracingクラスからコールバックされる関数
		private void DrawPixel(Point pt, Color color)
		{
			canvas.SetPixel(pt.X, pt.Y, color);
		}
	}
}
