//	ATtiny13A
//	Ni-MH[dr̕d
//	wt]xH쎺	http://jsdiy.web.fc2.com

/*
y|[gΉz	ATtiny13A	x:݂Ȃ(PB5RESET) -:
bit		7	6	5	4	3	2	1	0
portB	x	x	x	ADC	ADC	ADC	baB	baA

PB4:drA̓dĎ, PB3:drB̓dĎ, PB2:I~d̐ݒ擾
PB1:drB̕d𐧌, PB0:drA̕d𐧌

yATtiny13Az
|VBBB|
|-210|
>    |
|534-|	sKȕяɒ
|BBBG|

yq[Yrbgz(ftavrw.exe -rf)	Hoאݒ Low:01101010(6A)
Low: -1101010 (6A)
     ||||||++-- CKSEL[1:0] VXeNbNI
     ||||++-- SUT[1:0] N
     |||+-- CKDIV8 NbNl (1:1/1, 0:1/8)
     ||+-- WDTON (WDT 0:펞ON, 1:ʏ)
     |+-- EESAVE (ChipEEPROM 0:ێ, 1:)
     +-- SPIEN (1:ISP֎~, 0:ISP) HVŜ

High:---11111 (FF)
        ||||+-- RSTDISBL (RESETs 1:L, 0:(PB5))
        ||++-- BODLEVEL[1:0] (11:Off, 10:1.8V, 01:2.7V, 00:4.3V)
        |+-- DWEN (On-ChipfobO 1:, 0:L)
        +-- SPMEN (SPM 1:, 0:L)

yrhz
Atmel Studio 6 (Version: 6.0.1996 - Service Pack 2)
AVR Toolchain 8 Bit / Version: 3.4.1.830 - GCC  4.6.2
ATtiny13A 1.2MHzi9.6MHz8j	œKIvV: -Os

yXVz
2013/09/08	v1.00	
	Program Memory Usage 	:	492 bytes   48.0 % Full
	Data Memory Usage 		:	0 bytes   0.0 % Full
*/


#include <avr/io.h>
#include <avr/sleep.h>
#include <avr/interrupt.h>
#include <util/delay.h>

typedef struct
{
	uint8_t	stopCount;
	uint8_t	channel;
	uint8_t	battI;
	uint8_t	IsFinished;
} TBattState;

static uint16_t	ADConvert(uint8_t channel);
static void	BattStateInit(TBattState* batt, uint8_t channel, uint8_t battI);
static void	BattStateCheck(TBattState* batt, const uint16_t adcValFinalV);
static void	ErrorIndicate();

#define	D_VREF	33		//(/10V)	ADCVrefi10{Pʂ̓dj
//#define	D_VREF	50		//(/10V)	ADCVrefi10{Pʂ̓dj
#define	ADCVAL_FinalV_Limit	(7U * 1023U / ((uint16_t)D_VREF))	//eI~dݒ̉li0.7VADClj
#define	ADCVAL_StartV_Limit	(15U * 1023U / ((uint16_t)D_VREF))	//edJnd̏li1.5VADClj

//s̊蓖
#define	BV_BattAV	_BV(PORTB4)
#define	BV_BattBV	_BV(PORTB3)
#define	BV_FinalV	_BV(PORTB2)
#define	BV_BattAI	_BV(PORTB0)
#define	BV_BattBI	_BV(PORTB1)

//d
#define	DischargeOn(bvBattI)	(PORTB |= (bvBattI))
#define	DischargeOff(bvBattI)	(PORTB &= ~(bvBattI))

//d REFS0 = 0:VCC, 1:1.1V
#define	FixedADMUX	(0 << REFS0)

//ADC`l؂ւ MUX1,0
#define ChBattAV	(0b10 << MUX0)	//PB4
#define ChBattBV	(0b11 << MUX0)	//PB3
#define ChFinalV	(0b01 << MUX0)	//PB2

//ADEN = 1:ADC싖, 0:sid͋~j
//ADIE = 1:ϊ̊荞݋, 0:荞ݏȂ
//ADPS2,1,0 = 001:2, 010:4, 011:8, 100:16, 101:32, 110:64, 111:128
#define	FixedADCSRA	((1 << ADEN) | (1 << ADIE) | (0b100 << ADPS0))

//ADC^sleep̕AړI̊荞
ISR(ADC_vect)
{
	//ɏȂ
}

//8bit^C}[^sleep̕AړI̊荞
ISR(TIM0_COMPA_vect)
{
	//ɏȂ
}

int	main(void)
{
	uint8_t	i;
	uint16_t	adcValFinalV;
	TBattState	battA, battB;
	
	//|[gݒ
	DDRB = BV_BattAI | BV_BattBI;
	DischargeOff(BV_BattAI);
	DischargeOff(BV_BattBI);
	
	//fW^͋֎~id͐ߖj
	DIDR0 = (1 << ADC1D) | (1 << ADC2D) | (1 << ADC3D);

	//ADCWX^
	ADMUX = FixedADMUX;
	ADCSRA = FixedADCSRA;

	//8bit^C}[JE^
	//TCCR0B:02,TCCR0A:WGM01,00 = 010:rv(OCR0A)
	//TCCR0B:CS02,01,00 = 000:~, 001:Ȃ, 010:8, 011:64, 100:256, 101:1024
	TCCR0A = (0b10 << WGM00);
	TCCR0B = (0b0 << WGM02) | (0b101 << CS00);	//1.2MHz/1024=1171.9JEg/b
	OCR0A = 234 - 1;	//JEgݒ	0.2b
	TIMSK0 = (1 << OCIE0A);	//^C}[JE^L
	
	//[dr̕dԂǗ\̂
	BattStateInit(&battA, ChBattAV, BV_BattAI);
	BattStateInit(&battB, ChBattBV, BV_BattBI);
	
	//ADCN^ǂݎ̂
	set_sleep_mode(SLEEP_MODE_ADC);		//ADCmCYጸ̃X[v[h
	sei();
	ADConvert(ChFinalV);
	
	//dJn
	while (1)
	{
		//[U[ݒ肵I~d(1.0V)𑪒肷
		//EI~d̐ݒlelĂꍇ͕dȂB
		adcValFinalV = ADConvert(ChFinalV);
		if (adcValFinalV < ADCVAL_FinalV_Limit)
		{
			ErrorIndicate();
			continue;
		}
		
		//[dr̕dԂĎ
		if (!battA.IsFinished) BattStateCheck(&battA, adcValFinalV);
		if (!battB.IsFinished) BattStateCheck(&battB, adcValFinalV);
		
		//Ď܂ŃC^[oui1̃X[v0.2bo߂j
		set_sleep_mode(SLEEP_MODE_IDLE);
		for (i = 0; i < 5; i++)
		{
			TCNT0 = 0;
			sleep_mode();
		}
		
		//ADCmCYጸ̃X[v[hɃZbg
		set_sleep_mode(SLEEP_MODE_ADC);
	}
	
	return 0;
}

static uint16_t	ADConvert(uint8_t channel)
{
	uint16_t adcValue;
	
	ADMUX = FixedADMUX | channel;	//`l؂ւ
	_delay_ms(10);
	sleep_mode();	//ADCJncϊcϊ
	adcValue = ADC;	//ǂݎ̂
	
	sleep_mode();	//ADCJncϊcϊ
	adcValue = ADC;
	return adcValue;
}

static void	BattStateInit(TBattState* batt, uint8_t channel, uint8_t battI)
{
	batt->stopCount = 0;
	batt->channel = channel;
	batt->battI = battI;
	batt->IsFinished = 0;
}

#define StopCountLimit	3

static void	BattStateCheck(TBattState* batt, const uint16_t adcValFinalV)
{
	uint16_t adcVal;
	
	adcVal = ADConvert(batt->channel);
	
	if (adcValFinalV < adcVal && adcVal < ADCVAL_StartV_Limit)
	{
		batt->stopCount = 0;
		DischargeOn(batt->battI);
	}
	else
	{
		batt->stopCount++;
		if (StopCountLimit <= batt->stopCount)
		{
			DischargeOff(batt->battI);
			batt->IsFinished = 1;
		}
	}
}

//I~d̐ݒlُł邱Ƃm点
//E2LEDɁupbpbcpbpbcvƌB
static void	ErrorIndicate()
{
	uint8_t	i;
	for (i = 0; i < 2; i++)
	{
		DischargeOn(BV_BattAI | BV_BattBI);
		_delay_ms(200);
		DischargeOff(BV_BattAI | BV_BattBI);
		_delay_ms(200);
	}
	_delay_ms(200);
}
