#ifndef	_LCDLIB_H_
#define	_LCDLIB_H_


#define		F_CPU	8000000UL	//8MHz

#include	<avr/io.h>
#include	<util/delay.h>

#define	LCD_DATA_PORT	PORTB	//PB7-PB0i8bit[hj
#define	LCD_CTRL_PORT	PORTD	//PD5, PD6
#define	LCD_DATA_DDR	DDRB
#define	LCD_CTRL_DDR	DDRD

//|[g̃rbg̊蓖āiRead/WriteWX^gpj
#define	LCD_RS	(1 << PD5)	//Register Select	H:data	L:command
#define	LCD_E	(1 << PD6)	//Enable Signal		H->L:strobe


void	lcdCmd(uint8_t bits);
void	lcdInit();
void	lcdCls();
void	lcdSetPos(int8_t x);	//x = 0-7, 0x40 + 0-7
void	lcdPutChar(char c);
void	lcdPutStr(const char* s);
void	lcdPutInt(int16_t n);
void	lcdPutUInt(uint16_t n);

//Instruction
#define	LCD_CMD_CLEAR_DISPLAY	0b00000001
#define	LCD_CMD_RETURN_HOME		0b00000010
#define	LCD_CMD_ENTRY_MODE		0b00000100
#define	LCD_CMD_DISPLAY_MODE	0b00001000
#define	LCD_CMD_CURSOR_MODE		0b00010000
#define	LCD_CMD_FUNCTION_SET	0b00100000
#define	LCD_CMD_SET_CGRAM_ADRS	0b01000000
#define	LCD_CMD_SET_DDRAM_ADRS	0b10000000

//Instructioñp[^
//(LCD_CMD_AAA | LCD_SUBCMD_XXX1 | LCD_SUBCMD_XXX2 | c)̌`Ŏg

//LCD_CMD_ENTRY_MODE						//ȉ̐͊ԈĂ邩mȂ
#define	LCD_SUBCMD_INCREMENT	0b00000010	//͈ʒui߂iw肾Decrementj
#define	LCD_SUBCMD_WITH_SHIFT	0b00000001	//\Vtg𔺂iLCD_CMD_CURSOR_MODEݒ肷j

//LCD_CMD_DISPLAY_MODE
#define	LCD_SUBCMD_SET_DISPLAY	0b00000100	//ʕ\iw肾ƕ\eۂ܂܉ʂj
#define	LCD_SUBCMD_SET_CURSOR	0b00000010	//J[\\
#define	LCD_SUBCMD_CURSOR_BLINK	0b00000001	//J[\_ł

//LCD_CMD_CURSOR_MODE
#define	LCD_SUBCMD_SHIFT_ON		0b00001000	//DDRAM̕ύXɕ\Vtgiw肾ƃJ[\ړj
#define	LCD_SUBCMD_RIGHT		0b00000100	//EփVtgiw肾ƍցjJ[\ړ[h͈ӖȂ

//LCD_CMD_FUNCTION_SET
#define	LCD_SUBCMD_DL8BIT		0b00010000	//Data Length 8-bitiw肾4-bit[hj
#define	LCD_SUBCMD_2LINE		0b00001000	//\2sgpiw肾1ŝݎgp\ɂȂj
#define	LCD_SUBCMD_FONT5X10		0b00000100	//Font Type 5x10iw肾5x8j


#endif	//_LCDLIB_H_
