//	ATtiny2313
//	LCD S-10551D Rg[
//	WinAVR-20080610	-Os


#include	<stdlib.h>	//utoa()
#include	<string.h>	//strlen()
#include	"lcdlib.h"

extern	char	data[];		//\̃obt@iMf[^̃obt@ƌpj
static	int8_t	lcdPos;

void	lcdCmd(uint8_t data)
{
	LCD_DATA_PORT = data;
	LCD_CTRL_PORT |= LCD_E;
	_delay_us(10);
	
	LCD_CTRL_PORT &= ~LCD_E;
	_delay_us(50);
}

void	lcdInit()
{
	LCD_DATA_DDR = 0b11111111;
	LCD_CTRL_DDR |= LCD_RS;
	LCD_CTRL_DDR |= LCD_E;
	
	LCD_DATA_PORT = 0;
	LCD_CTRL_PORT &= ~LCD_RS;
	LCD_CTRL_PORT &= ~LCD_E;
	
	_delay_ms(15);
	lcdCmd(0b00110000);
	_delay_ms(5);
	lcdCmd(0b00110000);
	_delay_us(100);
	lcdCmd(0b00110000);
	
	//   bit:76543210
	lcdCmd(0b00111000);		//Function Set	[bit:5]	DL=8-bit(1), N=2lines(1), *(0), *(0), *(0)
	lcdCmd(0b00001000);		//Display Set	[bit:3]	D=Set Display:NO(0), C=Set Cursor:NO(0), B=Cursor Blink:NO(0)
	lcdCmd(0b00001100);		//Display Set	[bit:3]	D=Set Display:YES(1), C=Set Cursor:NO(0), B=Cursor Blink:NO(0)
	lcdCmd(0b00000110);		//Entry Mode	[bit:2]	I/D=Increment(1), S=With Display Shift:NO(0)
	lcdCls();				//Clear Display
	
	lcdPos = 0;
}

void	lcdCls()
{
	lcdCmd(LCD_CMD_CLEAR_DISPLAY);
	_delay_ms(2);	//ClearDisplay͒xR}hȂ̂(s1.52ms)Aԑ҂Kv
}

void	lcdSetPos(int8_t x)
{
	lcdPos = x;
	lcdCmd(LCD_CMD_SET_DDRAM_ADRS | x);		//x = 0-7, 0x40 + 0-7
}

void	lcdPutChar(char c)
{
	LCD_DATA_PORT = c;
	LCD_CTRL_PORT |= LCD_RS;
	LCD_CTRL_PORT |= LCD_E;
	_delay_us(10);
	
	LCD_CTRL_PORT &= ~LCD_E;
	LCD_CTRL_PORT &= ~LCD_RS;
	_delay_us(50);
}

void	lcdPutStr(const char* s)
{
	lcdSetPos(lcdPos);
	
	while (*s != '\0')
		lcdPutChar(*s++);
}

static void	putInt(uint16_t n, uint8_t offset)
{
	uint8_t	i;
	utoa(n, data + offset, 10);
	
	i = strlen(data);
	while (i < 6) data[i++] = ' ';	//"-32768"ōő6
	data[i] = '\0';
	
	lcdPutStr(data);
}

void	lcdPutInt(int16_t n)
{
	if (n < 0)
	{
		data[0] = '-';
		putInt(-n, 1);
	}
	else
	{
		lcdPutUInt(n);
	}
}

void	lcdPutUInt(uint16_t n)
{
	putInt(n, 0);
}
