//	ATtiny2313
//	LCD S-10551D Rg[
//
//	ES-10551Dc16x1sAobNCgȂBRg[͓HD44780A00݊
//	EVAʐMŕA\BWp[sŃ{[[gύX\

/*
	|[gΉ	[ATtiny2313]	-:	x:݂ȂiPA2RESETj
	bit		7	6	5	4	3	2	1	0
	portA	x	x	x	x	x  (x)	BR	BR		{[[g
	portB	DB7	DB6	DB5	DB4	DB3	DB2	DB1	DB0		LCD̃f[^rbg
	portD	x	E	RS	-	-	-	TXD	RXD		LCDEALCDRSAVAʐM
	
	{[[gݒ
	38400bps		19200bps		9600bps			4800bps
	GNDEEPA1		GND||PA1		GNDEbPA1		GNDbEPA1
	GND||PA0		GNDEEPA0		GNDEbPA0		GNDbEPA0
	
	rh
	WinAVR-20080610		œKIvV:-Os
	ATtiny2313	8MHz Ȃ
	
	
	2009/08/29	v0.01	JJn
	2009/09/05	v0.90	b芮	Program:     952 bytes (46.5% Full)
									Data:         15 bytes (11.7% Full)
*/


#include	<avr/io.h>
#include	"lcdlib.h"

#define	nop()	asm volatile("nop"::)

#define	BUF_SIZE	(1 + 8 + 1)		//f[^^:1byte + f[^{:8byte܂ + f[^̃kI[̕:1byte
char	data[BUF_SIZE] = {0};		//Mobt@

enum	E_DATA_TYPE
{
	CMD_CLS				= 0x00,
	CMD_SET_POS			= 0x01,
	
	DATA_TYPE_INT8		= 0x10,
	DATA_TYPE_UINT8		= 0x20,
	DATA_TYPE_INT16		= 0x30,
	DATA_TYPE_UINT16	= 0x40,
	DATA_TYPE_CHAR		= 0x50,
	DATA_TYPE_STR		= 0x60
};

static	uint16_t	setBaudRate();
static	void	cmdExec(uint8_t cmdType, uint8_t data);

int	main(void)
{
	uint8_t		didx = 0;		//Mobt@̃CfbNX
	uint8_t		dataType = 0, dataLength = 0;
	uint8_t		value8bit;		//8rbgf[^̈ꎞIȒl
	uint16_t	value16bit;		//16rbgf[^̈ꎞIȒl
	
	//LCD
	lcdInit();
	
	//ʐMxݒ肷
	lcdSetPos(0);
	lcdPutUInt(setBaudRate());
	lcdSetPos(0x40);
	lcdPutStr("bps");
	lcdSetPos(0);
	
	while (1)
	{
		//VAʐMM҂
		while (!(UCSRA & (1 << RXC)));	//MŃrbgwhile𔲂
		
		//Mf[^(1byte)擾
		data[didx] = UDR;
		if (didx == 0)
		{
			dataType 	= data[0] & 0xF0;
			dataLength	= data[0] & 0x0F;
		}
		
		//Sf[^M
		//Ef[^{̂data[1]i[iCfbNXƃf[^̑Ήxvj
		if (didx++ < dataLength) continue;
		
		//Mf[^H
		//E16rbgf[^̓gGfBAŔzɊi[ĂƂiAVR̓gGfBAj
		//Ef[^̓kI[ĂȂ
		value8bit = (uint8_t)data[1];
		value16bit = *(uint16_t*)(&data[1]);	//16rbgƉ肵gݗ
		data[didx] = '\0';	//f[^Ɖ肵kI[ߍ
		
		//\̐U蕪
		switch (dataType)
		{
		case DATA_TYPE_INT8:
			lcdPutInt((int8_t)value8bit);
			break;
			
		case DATA_TYPE_UINT8:
			lcdPutUInt((uint8_t)value8bit);
			break;
			
		case DATA_TYPE_INT16:
			lcdPutInt((int16_t)value16bit);
			break;
			
		case DATA_TYPE_UINT16:
			lcdPutUInt((uint16_t)value16bit);
			break;
			
		case DATA_TYPE_CHAR:
			lcdPutChar(value8bit);
			break;
			
		case DATA_TYPE_STR:
			lcdPutStr(&data[1]);
			break;
			
		default:
			cmdExec(dataLength, value8bit);
			break;
		}
		
		didx = 0;
		dataType = 0;
		dataLength = 0;
		
	}	//while()
	
	return 0;
}

//R}hs
static	void	cmdExec(uint8_t cmdType, uint8_t data)
{
	switch (cmdType)
	{
	case CMD_SET_POS:
		lcdSetPos(data);
		break;
		
	//case CMD_CLS:
	default:
		lcdCls();
		while (UCSRA & (1 << RXC)) data = UDR;	//Mobt@ɂ
		break;
	}
}

//ʐMxݒ肷
static	uint16_t	setBaudRate()
{
	uint8_t	sw;
	uint16_t	baudRate;
	
	DDRA	= 0b00000000;
	PORTA	= 0b00000011;
	nop();
	nop();
	sw = PINA;
	if (~sw & _BV(PA0))
	{
		//38400bps
		UBRRL	= F_CPU / 38400 / 16 - 1;
		baudRate = 38400;
	}
	else if (~sw & _BV(PA1))
	{
		//19200bps
		UBRRL	= F_CPU / 19200 / 16 - 1;
		baudRate = 19200;
	}
	else
	{
		DDRA	= 0b00000010;
		PORTA	= 0b00000001;
		nop();
		nop();
		sw = PINA;
		if (~sw & _BV(PA0))
		{
			//9600bps
			UBRRL	= F_CPU / 9600 / 16 - 1;
			baudRate = 9600;
		}
		else
		{
			//4800bps
			UBRRL	= F_CPU / 4800 / 16 - 1;
			baudRate = 4800;
		}
	}
	DDRA	= 0;
	PORTA	= 0;
	
	//VAʐM
	//UMSEL=0:񓯊, UPM1/0=00:peBȂ, USBS=0:Xgbvrbg1, UCSRB:UCSZ2-UCSRC:UCSZ1/0=011:f[^8rbg
	UBRRH	= 0;
//	UBRRL	= Zol;
	UCSRB	= (1 << RXEN) | (1 << TXEN) | (0 << UCSZ2);		//RXD(PD0),TXD(PD1)Lɂ
	UCSRC	= (0 << UMSEL) | (0 << UPM1) | (0 << UPM0) | (0 << USBS) | (1 << UCSZ1) | (1 << UCSZ0);
	
	return baudRate;
}
